/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.collision;

import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.utils.YuushyaLogger;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CollisionNetWorkChannel {
    public static final NetworkChannel INSTANCE = NetworkChannel.create((ResourceLocation)new ResourceLocation("yuushya", "collision"));

    public static void encoder(AllCollisionPack allPack, FriendlyByteBuf byteBuf) {
        byteBuf.m_236831_(allPack.map, (buf, blockstate) -> buf.writeInt(blockstate.intValue()), (buf, voxelShape) -> {
            List list = voxelShape.m_83299_();
            buf.m_130130_(list.size());
            for (AABB aabb : list) {
                buf.writeDouble(aabb.f_82288_);
                buf.writeDouble(aabb.f_82289_);
                buf.writeDouble(aabb.f_82290_);
                buf.writeDouble(aabb.f_82291_);
                buf.writeDouble(aabb.f_82292_);
                buf.writeDouble(aabb.f_82293_);
            }
        });
    }

    public static AllCollisionPack decoder(FriendlyByteBuf byteBuf) {
        return new AllCollisionPack(byteBuf.m_236847_(buf -> buf.readInt(), buf -> {
            int len = buf.m_130242_();
            VoxelShape voxelShape = Shapes.m_83040_();
            for (int i = 0; i < len; ++i) {
                voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Shapes.m_166049_((double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble()));
            }
            return voxelShape;
        }));
    }

    public static void handler(AllCollisionPack allPack, Supplier<NetworkManager.PacketContext> ctx) {
        YuushyaBlockFactory.getYuushyaVoxelShapes().putAll(allPack.map);
    }

    public static void sendAllToClient(ServerPlayer player) {
        YuushyaLogger.info("i1iio" + YuushyaBlockFactory.getYuushyaVoxelShapes().size());
        List list = YuushyaBlockFactory.getYuushyaVoxelShapes().entrySet().stream().toList();
        int len = list.size();
        for (int i = 0; i < len; i += 200) {
            List subList = list.subList(i, Math.min(len, i + 200));
            AllCollisionPack allPack = new AllCollisionPack(subList.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            INSTANCE.sendToPlayer(player, (Object)allPack);
        }
        YuushyaLogger.info("i2iio" + YuushyaBlockFactory.getYuushyaVoxelShapes().size());
    }

    public static void register() {
        INSTANCE.register(AllCollisionPack.class, CollisionNetWorkChannel::encoder, CollisionNetWorkChannel::decoder, CollisionNetWorkChannel::handler);
    }

    public static class AllCollisionPack {
        public Map<Integer, VoxelShape> map = new HashMap<Integer, VoxelShape>();

        public AllCollisionPack(Map<Integer, VoxelShape> map) {
            this.map.putAll(map);
        }
    }
}

